<?php
/**
 * Block Patterns
 *
 * @since 1.0.0
 */

/**
 * Registers pattern categories for Grocery Online Store
 *
 * @since 1.0.0
 *
 * @return void
 */
function grocery_online_store_register_pattern_category() {
	$block_pattern_categories = array(
		'all'      => array( 'label' => __( 'Grocery Online Store Patterns', 'grocery-online-store' ) ),
		'home'     => array( 'label' => __( 'Home', 'grocery-online-store' ) ),
		'pricing'  => array( 'label' => __( 'Pricing Table', 'grocery-online-store' ) ),
		'callback' => array( 'label' => __( 'Call to Action', 'grocery-online-store' ) ),
	);

	$block_pattern_categories = apply_filters( 'grocery_online_store_block_pattern_categories', $block_pattern_categories );

	foreach ( $block_pattern_categories as $name => $properties ) {
		if ( ! WP_Block_Pattern_Categories_Registry::get_instance()->is_registered( $name ) ) {
			register_block_pattern_category( $name, $properties ); // phpcs:ignore WPThemeReview.PluginTerritory.ForbiddenFunctions.editor_blocks_register_block_pattern_category
		}		
	}
}
add_action( 'init', 'grocery_online_store_register_pattern_category', 9 );


