<?php
add_action( 'admin_menu', 'legal_counselor_getting_started' );
function legal_counselor_getting_started() {
	add_theme_page( esc_html__('Get Started', 'legal-counselor'), esc_html__('Get Started', 'legal-counselor'), 'edit_theme_options', 'legal-counselor-guide-page', 'legal_counselor_test_guide');
}

// Add a Custom CSS file to WP Admin Area
function legal_counselor_admin_theme_style() {
   wp_enqueue_style('custom-admin-style', esc_url(get_template_directory_uri()) . '/inc/get-started/get-started.css');
}
add_action('admin_enqueue_scripts', 'legal_counselor_admin_theme_style');

//guidline for about theme
function legal_counselor_test_guide() { 
	//custom function about theme customizer
	$return = add_query_arg( array()) ;
	$theme = wp_get_theme( 'legal-counselor' );
?>
<div class="wrapper-info">
	<div class="intro">
			<h3><?php esc_html_e( 'Welcome to Free Legal Counselor WordPress Theme', 'legal-counselor' ); ?></h3>
			<p><?php esc_html_e('Version: ','legal-counselor'); ?><?php echo esc_html($theme['Version']);?></p>
		</div>
	<div class="col-left">
		<div class="started">
			<hr>
			<div class="centerbold">
				<h4><?php esc_html_e('Pro version of our theme', 'legal-counselor'); ?></h4>
				<p><?php esc_html_e('Are you exited for our theme? Then we will proceed for pro version of theme.', 'legal-counselor'); ?></p>
				<a class="bg-color" href="<?php echo esc_url( LEGAL_COUNSELOR_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Buy Now', 'legal-counselor'); ?></a>
				<hr>
				<h4><?php esc_html_e('Check Our Demo', 'legal-counselor'); ?></h4>
				<p><?php esc_html_e('Here, you can view a live demonstration of our theme.', 'legal-counselor'); ?></p>
				<a class="bg-color" href="<?php echo esc_url( LEGAL_COUNSELOR_PRO_DEMO ); ?>" target="_blank"><?php esc_html_e('Theme Demo', 'legal-counselor'); ?></a>
				<hr>
				<h4><?php esc_html_e('Theme Documentation', 'legal-counselor'); ?></h4>
				<p><?php esc_html_e('Need more details? Please check our full documentation for detailed theme setup.', 'legal-counselor'); ?></p>
				<a href="<?php echo esc_url( LEGAL_COUNSELOR_THEME_DOC ); ?>" target="_blank"><?php esc_html_e('Pro Documentation', 'legal-counselor'); ?></a>
				<hr>
				<h4><?php esc_html_e('Need Help?', 'legal-counselor'); ?></h4>
				<p><?php esc_html_e('Go to our support forum to help you out in case of queries and doubts regarding our theme.', 'legal-counselor'); ?></p>
				<a href="<?php echo esc_url( LEGAL_COUNSELOR_SUPPORT ); ?>" target="_blank"><?php esc_html_e('Support', 'legal-counselor'); ?></a>
				<hr>
				<h4><?php esc_html_e('Leave us a review', 'legal-counselor'); ?></h4>
				<p><?php esc_html_e('Are you enjoying our theme? We would love to hear your feedback.', 'legal-counselor'); ?></p>
				<a href="<?php echo esc_url( LEGAL_COUNSELOR_REVIEW ); ?>" target="_blank"><?php esc_html_e('Review', 'legal-counselor'); ?></a>
			</div>
		</div>
	</div>
	<div class="col-right">
		<div class="col-left-inner"> 
			<img role="img" src="<?php echo esc_url(get_template_directory_uri()); ?>/inc/get-started/images/screenshot.png" alt="" />
		</div>
	</div>
</div>
<?php } ?>